#!/usr/bin/perl
# 
# ***** BEGIN LICENSE BLOCK *****
# Zimbra Collaboration Suite Server
# Copyright (C) 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software Foundation,
# version 2 of the License.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# You should have received a copy of the GNU General Public License along with this program.
# If not, see <https://www.gnu.org/licenses/>.
# ***** END LICENSE BLOCK *****
# 


use strict;
use Migrate;
my $concurrent = 10;

my $sqlGroupsWithSmallMetadata = <<_SQL_;
SELECT table_schema FROM information_schema.columns
WHERE table_name = 'mail_item' AND column_name = 'metadata' AND data_type = 'text'
ORDER BY table_schema;
_SQL_
my @groups = Migrate::runSql($sqlGroupsWithSmallMetadata);

Migrate::verifySchemaVersion(37);

my @sql = ();
foreach my $group (@groups) {
    my $sql = <<_SQL_;
ALTER TABLE $group.mail_item MODIFY COLUMN metadata MEDIUMTEXT;
_SQL_
    push(@sql, $sql);
}
Migrate::runSqlParallel($concurrent, @sql);

Migrate::updateSchemaVersion(37, 38);

exit(0);
